/************************************************************************/
/*									*/
/*			A R C S T A T . C				*/
/*			-----------------				*/
/*									*/
/*	Copyright (C) 1988 Digital Research Inc. All rights		*/
/*	reserved. The Software Code contained in this listing is	*/
/*	proprietary to Digital Research Inc., Monterey,			*/
/*	California, and is covered by U.S. and other copyright		*/
/*	protection. Unauthorized copying, adaption, distribution,	*/
/*	use or display is prohibited and may be subject to civil	*/
/*	and criminal penalties. Disclosure to others is			*/
/*	prohibited. For the terms and conditions of software use,	*/
/*	refer to the appropriate Digital Research Licence		*/
/*	Agreement.							*/
/*									*/
/************************************************************************/
/*									*/
/*	Sample NIOS status for several popular ARCNET cards for IBM PCs	*/
/*									*/
/*	Written by:	JW, Digital Research EDC, Hungerford, GB	*/
/*									*/
/*	Date	   Who  Modification					*/
/*	---------  ---	-------------------------------------------	*/
/*	 8-Dec-88  JW	initially written				*/
/*									*/
/************************************************************************/

#include <stdio.h>
#include "i:portab.h"
#include <dos.h>

#define BOOL BOOLEAN			/* YES/NO values */

#if NUM_I_LDCB == 1
#define ARC_MAGIC 0x14a
#endif
#if NUM_I_LDCB == 2
#define ARC_MAGIC 0x160
#endif

typedef struct
{
	UWORD transmit_error;		/* transmit error count */
	UWORD retry_count [15];		/* retry counters */
	UWORD rx_err_count;		/* receive error counter */
	UWORD xp_err_count;		/* transport timeout counter */
	UWORD tmt_err_count;		/* dos plus session timeout counter */
	UWORD recon_count;		/* reconfiguration counter */
	UWORD tx_buff_count;		/* no tx buffers counter */
	UWORD rx_buff_count;		/* no rx buffers counter */
	UWORD dl_err_count;		/* datalink tx timeout counter */
	UWORD discard_count;		/* abort tx timeout counter */
	UWORD rcv_off_count;		/* rx disabled counter */
	UWORD por_count;		/* Power On Reset Counter */
}	NINFO;

union
{
	struct
	{
	    UWORD buffo;
	    UWORD buffs;
	} w;
	UWORD FAR *buffp;
}	bufvar;

#define	bufoff	bufvar.w.buffo		/* buffer offset */
#define	bufseg	bufvar.w.buffs		/* virtual buffer segment */
#define	bufptr	bufvar.buffp		/* virtual buffer address */


BYTE msg_hdng [] =
{
	"ARCSTAT 2.01  Copyright (C) 1988 Digital Research"
};

BYTE msg_line1 [] =
{
	"Retry counts:"
};

BYTE msg_line2 [] =
{
	"Receive Xport   Receive Recon   No TX   "
	"No RX  Datalink Discard Rx"
};

BYTE msg_line3 [] =
{
	"error   timeout timeout occured buffer  "
	"buffer  tx tout count   disable"
};

BYTE msg_line4 [] =
{
	"------- ------- ------- ------- ------- "
	"------- ------- ------- -------"
};

WORD CDECL write (WORD h, VOID *b, UWORD n)
{
	_BX = h;
	_DX = (UWORD) b;
	_CX = n;
	_AH = 0x40;
	geninterrupt(0x21);
	return (_CX);
}

VOID PASCAL cls (VOID)
{
	printf ("\x1b" "E");
}

VOID PASCAL cpos (WORD r, WORD c)
{
	printf ("\x1b" "Y%c%c", r+32, c+32);
}


VOID PASCAL p_delay (WORD count)
{
	_DX = count;
	_CL = 141;
	geninterrupt (224);
}


VOID main (WORD argc, BYTE **argv)
{
	WORD i;
	BOOLEAN virgin = YES;
	WORD irq;
	NINFO FAR *ninfo;
	NINFO ncopy;

	if ((*((BYTE FAR *) 0xFFFF000E) == 0xFC) ||
	    (*((BYTE FAR *) 0xFFFF000E) == 0xF8))
	    irq = 9;			/* default for AT/70/80 */
	else
	    irq = 2;			/* default for PC/XT */

	for (i=1; i<argc; i++)
	{
	    if (!strncmp (argv[i], "-i", 2))
		irq = atoi (argv[i]+2);
	}

	if ((irq >= 2) && (irq <= 7))
	    irq += 0x08;
	else if ((irq >= 8) && (irq <= 15))
	    irq += 0x70-8;
	else
	{
	    fprintf (stderr, "Invalid IRQ: Use \"-iN\"\n");
	    fprintf (stderr, "where N is in the range 2..15\n");
	    exit (1);
	}

	bufseg = 0x0000;
	bufoff = irq * 4;

	bufseg = bufptr[1];
	bufoff = 0x0000;		/* NIOSDS at NIOSCS:0 */
	bufseg = *bufptr;
	bufoff = ARC_MAGIC;		/* info data at NIODS:ARC_MAGIC */

	ninfo = (VOID FAR *) bufptr;	/* get network info address */

	cls ();
	cpos (0, 18);
	printf (msg_hdng);
	
	cpos (2, 35);
	printf (msg_line1);
	cpos (3, 0);
	for (i=1; i<=15; i++)
	    printf ("%3d  ", i);
	cpos (4, 0);
	for (i=1; i<=15; i++)
	    printf ("---- ", i);
	cpos (7, 0);
	printf (msg_line2);
	cpos (8, 0);
	printf (msg_line3);
	cpos (9, 0);
	printf (msg_line4);

	FOREVER
	{
	    for (i=0; i<15; i++)
	    {
	        if (virgin ||
		    (ninfo->retry_count[i] != ncopy.retry_count[i]))
		{
		    cpos (5, i*5);
		    printf ("%4d", ninfo->retry_count[i]);
		    ncopy.retry_count[i] = ninfo->retry_count[i];
		}
	    }

	    for (i=15; i<24; i++)
	    {
	        if (virgin ||
		    (ninfo->retry_count[i] != ncopy.retry_count[i]))
		{
		    cpos (10, (i-15)*8);
		    printf ("%7d", ninfo->retry_count[i]);
		    ncopy.retry_count[i] = ninfo->retry_count[i];
		}
	    }

	    cpos (16, 78);
	    p_delay (10);		/* wait a sixth of a second */

	    virgin = NO;		/* we've done it at least once... */
	}

}
